/* Simulator definitions

   Copyright (c) 1993, 1994, Robert M Supnik, Digital Equipment Corporation
   Commercial use prohibted

   The interface between the simulator control package (SCP) and the
   simulator consists of the following routines and data structures

	sim_name		simulator name string
	sim_devices[]		array of pointers to simulated devices
	sim_PC			pointer to saved PC register descriptor
	sim_interval		simulator interval to next event
	sim_stop_messages	array of pointers to stop messages
	sim_instr()		instruction execution routine
	sim_load()		binary loader routine
*/

/*
 SIM_DEFS.H
 Revision 1.6  1995/01/29 02:36:24  T.V.Kutergin
 Added conditional compilation statements around SEEK_xxx definitions

 Revision 1.5  1995/01/29 02:14:49  T.V.Kutergin
 KOI7 set on

 Revision 1.4  1995/01/29 02:11:08  T.V.Kutergin
 Added KOI7 support and CR/LF expansion for LPT.

 Revision 1.3  1995/01/28 23:08:36  T.V.Kutergin
 Added ASCII / KOI7 mode switching for TTI and TTO (for Russian users)
 Commands: SET TTI ASCII/KOI7  and SET TTO ASCII/KOI7

 Revision 1.2  1995/01/23 16:56:41  T.V.Kutergin
 Implemented partial VT52 emulation

 Revision 1.1  1995/01/22 05:10:49  T.V.Kutergin
 Initial revision

*/

#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <assert.h>

/* booleans              */
typedef unsigned char    Boolean;
#ifndef TRUE
#define TRUE		1
#define FALSE		0
#endif

/* file seek codes       */
#ifndef SEEK_SET
#define SEEK_SET    0                    /* absolute positioning */
#define SEEK_CUR    1                    /* relative positioning */
#define SEEK_END    2                    /* seek from end of file*/
#endif

/* various flage         */
#define MEM_DYNAMIC                      /* allocate memory dyn. */
#define FLUSH_CHDEV                      /* flush char.device    */
#define RCS_INVOKED                      /* insert RCS version   */
#define KOI7                             /* allow Russian chars  */
#define CLS_ON_INIT                      /* clr screen init/exit */
#define KEY_STOP         0x172           /* Sim.abort key        */


#ifdef  KOI7
/* KOI7/ASCII TI/TO flag */
#define UNIT_V_KOI7      (UNIT_V_UF)     /* present              */
#define UNIT_KOI7        (1<<UNIT_V_KOI7)
#endif


/* Debug flags           */
/* #define DEBUG_DUMP    */

#ifdef  DEBUG_DUMP
#define DUMP_MSDOS_IO                    /* MS-DOS I/O dump      */
#define DUMP_BAD_IOADR                   /* dump bad I/O adress  */
#define DUMP_MODE_CHANGE                 /* dump change CPU mode */
#define DUMP_OLDPC                       /* use not incr PC      */
#define DUMP_INSTR                       /* dump important instr */
#define DUMP_TRAPS                       /* dump traps activity  */
#define DUMP_INTERRUPTS                  /* dump interrupts      */
#define DUMP_RELOCC                      /* console reloc.dump   */

#ifdef  DUMP_INSTR
#define DUMP_INSTR_HALT                  /* dump HALT instruction*/
#define DUMP_INSTR_WAIT                  /* dump WAIT instruction*/
#define DUMP_INSTR_BPT                   /* dump BPT  instruction*/
#define DUMP_INSTR_IOT                   /* dump IOT  instruction*/
#define DUMP_INSTR_RESET                 /* dump RESET instruct. */
#define DUMP_INSTR_RTI                   /* dump RTI  instruction*/
#define DUMP_INSTR_MFPT                  /* dump MFPT instruction*/
#define DUMP_INSTR_MFPI                  /* dump MFPI instruction*/
#define DUMP_INSTR_MTPI                  /* dump MTPI instruction*/
#define DUMP_INSTR_MTPS                  /* dump MTPS instruction*/
#define DUMP_INSTR_MFPD                  /* dump MFPD instruction*/
#define DUMP_INSTR_MTPD                  /* dump MTPD instruction*/
#define DUMP_INSTR_MFPS                  /* dump MFPS instruction*/
#define DUMP_INSTR_EMT                   /* dump EMT  instruction*/
#define DUMP_INSTR_TRAP                  /* dump TRAP instruction*/
#endif
#endif


/* Simulator status codes

   0			ok
   1 - (SCPE_BASE - 1)	simulator specific
   SCPE_BASE - n	general
*/

#define SCPE_OK		0				/* normal return */
#define SCPE_BASE	32				/* base for messages */
#define SCPE_NXM	(SCPE_BASE + 0)			/* nxm */
#define SCPE_UNATT	(SCPE_BASE + 1)			/* no file */
#define SCPE_IOERR 	(SCPE_BASE + 2)			/* I/O error */
#define SCPE_CSUM	(SCPE_BASE + 3)			/* loader cksum */
#define SCPE_FMT	(SCPE_BASE + 4)			/* loader format */
#define SCPE_NOATT	(SCPE_BASE + 5)			/* not attachable */
#define SCPE_OPENERR	(SCPE_BASE + 6)			/* open error */
#define SCPE_MEM	(SCPE_BASE + 7)			/* alloc error */
#define SCPE_ARG	(SCPE_BASE + 8)			/* argument error */
#define SCPE_STEP	(SCPE_BASE + 9)			/* step expired */
#define SCPE_UNK	(SCPE_BASE + 10)		/* unknown command */
#define SCPE_RO		(SCPE_BASE + 11)		/* read only */
#define SCPE_INCOMP	(SCPE_BASE + 12)		/* incomplete */
#define SCPE_STOP	(SCPE_BASE + 13)		/* sim stopped */
#define SCPE_EXIT	(SCPE_BASE + 14)		/* sim exit */
#define SCPE_TTIERR	(SCPE_BASE + 15)		/* console tti err */
#define SCPE_TTOERR	(SCPE_BASE + 16)		/* console tto err */
#define SCPE_EOF	(SCPE_BASE + 17)		/* end of file */
#define SCPE_REL	(SCPE_BASE + 18)		/* relocation error */
#define SCPE_NOPARAM	(SCPE_BASE + 19)		/* no parameters */
#define SCPE_ALATT	(SCPE_BASE + 20)		/* already attached */
#define SCPE_KFLAG	01000				/* tti data flag */

/* Constants */

#define CBUFSIZE	128				/* string buf size */
#define PV_RZRO		0				/* right, zero fill */
#define PV_RSPC		1				/* right, space fill */
#define PV_LEFT		2				/* left justify */

/* Default timing parameters */

#define KBD_POLL_WAIT	5000				/* keyboard poll */
#define SERIAL_IN_WAIT	100				/* serial in time */
#define SERIAL_OUT_WAIT	10				/* serial output */
#define NOQUEUE_WAIT	10000				/* min check time */

/* Convert switch letter to bit mask */

#define SWMASK(x) (1 << (((int) (x)) - ((int) 'A')))

/* String match */

#define MATCH_CMD(ptr,cmd) strncmp ((ptr), (cmd), strlen (ptr))

/* Device data structure */

struct device {
	char		*name;				/* name */
	struct unit 	*units;				/* units */
	struct reg	*registers;			/* registers */
	struct mtab	*modifiers;			/* modifiers */
	int		numunits;			/* #units */
	int		aradix;				/* address radix */
	int		awidth;				/* address width */
	int		aincr;				/* addr increment */
	int		dradix;				/* data radix */
	int		dwidth;				/* data width */
	int		(*examine)();			/* examine routine */
	int		(*deposit)();			/* deposit routine */
	int		(*reset)();			/* reset routine */
	int		(*boot)();			/* boot routine */
	int		(*attach)();			/* attach routine */
	int		(*detach)();			/* detach routine */
};

/* Unit data structure

   Parts of the unit structure are device specific, that is, they are
   not referenced by the simulator control package and can be freely
   used by device simulators.  Fields starting with 'buf', and flags
   starting with 'UF', are device specific.  The definitions given here
   are for a typical sequential device.
*/

struct unit {
	struct unit	*next;				/* next active */
	int		(*action)();			/* action routine */
	char		*filename;			/* open file name */
	FILE		*fileref;			/* file reference */
	void		*filebuf;			/* memory buffer */
	int		hwmark;				/* high water mark */
	int		time;				/* time out */
	int		flags;				/* flags */
	int		capac;				/* capacity */
	int		pos;				/* file position */
	int		buf;				/* buffer */
	int		wait;				/* wait */
	int		u3;				/* device specific */
	int		u4;				/* device specific */
};

/* Unit flags */

#define UNIT_ATTABLE	000001				/* attachable */
#define UNIT_RO		000002				/* read only */
#define UNIT_FIX	000004				/* fixed capacity */
#define UNIT_SEQ	000010				/* sequential */
#define UNIT_ATT	000020				/* attached */
/* unused		000040 */
#define UNIT_BUFABLE	000100				/* bufferable */
#define UNIT_MUSTBUF	000200				/* must buffer */
#define UNIT_BUF	000400				/* buffered */
#define UNIT_V_UF	9				/* device specific */

/* Register descriptor */

struct reg {
	char		*name;				/* name */
	void		*loc;				/* location */
	int		radix;				/* radix */
	int		width;				/* width */
	int		offset;				/* starting bit */
	int		flags;				/* flags */
};

#define REG_FMT		003				/* see PV_x */
#define REG_RO		004				/* read only */
#define REG_HIDDEN	010				/* hidden */
#define REG_HRO		(REG_RO + REG_HIDDEN)		/* hidden, read only */

/* Command table */

struct ctab {
	char		*name;				/* name */
	int		(*action)();			/* action routine */
	int		arg;				/* argument */
};

/* Modifier table */

struct mtab {
	int		mask;				/* mask */
	int		match;				/* match */
	char		*pstring;			/* print string */
	char		*mstring;			/* match string */
	int		(*valid)();			/* validation routine */
};

/* The following macros define structure contents */

#define UDATA(act,fl,cap) NULL,act,NULL,NULL,NULL,0,0,(fl),(cap),0,0

#ifndef __STDC__
#define ORDATA(nm,loc,wd) "nm", &(loc), 8, (wd), 0
#define DRDATA(nm,loc,wd) "nm", &(loc), 10, (wd), 0
#define HRDATA(nm,loc,wd) "nm", &(loc), 16, (wd), 0
#define FLDATA(nm,loc,pos) "nm", &(loc), 2, 1, (pos)
#define GRDATA(nm,loc,rdx,wd,pos) "nm", &(loc), (rdx), (wd), (pos)
#else
#define ORDATA(nm,loc,wd) #nm, &(loc), 8, (wd), 0
#define DRDATA(nm,loc,wd) #nm, &(loc), 10, (wd), 0
#define HRDATA(nm,loc,wd) #nm, &(loc), 16, (wd), 0
#define FLDATA(nm,loc,pos) #nm, &(loc), 2, 1, (pos)
#define GRDATA(nm,loc,rdx,wd,pos) #nm, &(loc), (rdx), (wd), (pos)
#endif

/* Typedefs for principal structures */

typedef struct device DEVICE;
typedef struct unit UNIT;
typedef struct reg REG;
typedef struct ctab CTAB;
typedef struct mtab MTAB;


#ifdef KOI7
unsigned char pc2pdpK7[];
unsigned char pdp2pcK7[];
#endif
unsigned char pc2pdpAS[];
unsigned char pdp2pcAS[];


