/*
   FILE......... : K7TOA.C
   DATE......... : 1995/02/02 03:29:50
   VERSION...... : 1.3
   AUTHOR....... : T.V.Kutergin
   DESCRIPTION.. : Alternative PC to KOI-7 translation
*/

/*
#K7TOA.C
#Revision 1.3  1995/02/02 03:29:50  T.V.Kutergin
#Fixed bug in KOI7->ASCII conversion table
#Added RAW/KOI7 switch for paper tape puncher/reader (for text files)
#
#Revision 1.2  1995/01/29 02:11:01  T.V.Kutergin
#Added KOI7 support and CR/LF expansion for LPT.
#
#Revision 1.1  1995/01/23 17:29:20  T.V.Kutergin
#Initial revision
#
*/

#include <stdio.h>

static unsigned char* rcsid  ="K7TOA.C 1.3 1995/02/02 03:29:50 T.V.Kutergin Exp";

static unsigned char pdp2pc[]={0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
                               0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
                               0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
                               0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
                               0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
                               0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
                               0x9E,0x80,0x81,0x96,0x84,0x85,0x94,0x83,0x95,0x88,0x89,0x8A,0x8B,0x8C,0x8D,0x8E,
                               0x8F,0x9F,0x90,0x91,0x92,0x93,0x86,0x82,0x9C,0x9B,0x87,0x98,0x9D,0x99,0x97,0x7F,
                               0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                               0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                               0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                               0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                               0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                               0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                               0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
                               0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define CR         0x0D
#define LF         0x0A
void main(int argc,char* argv[])
{FILE *in,*out;
 short c,incr,inlf;
   if (argc == 3)
   {
      in=fopen(argv[1],"rb");
      if (in!=NULL)
      {
         out=fopen(argv[2],"wb");
         if (out!=NULL)
         {
            incr=inlf=0;
            while ((c=getc(in))!=EOF)
            {
               if (c==CR)
               {
                  if (incr)
                  {
                     putc(CR,out); putc(LF,out);
                  }
                  else if (inlf)
                  {
                     putc(CR,out); putc(LF,out);
                     inlf=0;
                  }
                  else
                     incr=1;
               }
               else if (c==LF)
               {
                  if (inlf)
                  {
                     putc(CR,out); putc(LF,out);
                  }
                  else if (incr)
                  {
                     putc(CR,out); putc(LF,out);
                     incr=0;
                  }
                  else
                     inlf=1;
               }
               else
               {
                  if (incr||inlf)
                  {
                     putc(CR,out); putc(LF,out); incr=inlf=0;
                  };
                  c=pdp2pc[c];
                  putc((c==0 ? ' ':c),out);
               };
            };
            if (incr||inlf)
            {
               putc(CR,out); putc(LF,out); incr=inlf=0;
            };
            fclose(out);
         }
         else
            printf("Error creating %s\n",argv[1]);
         fclose(in);
      }
      else
         printf("Error opening %s\n",argv[1]);
   }
   else
      printf("Usage: K7TOA <source> <dest>\n");
};

/* EOF : K7TOA.C */

